<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Mailer\Email;
use Cake\ORM\Table;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;

class UsersController extends AppController
{
	
	public function initialize()
    {
    	 parent::initialize();
        $this->Auth->allow(['login', 'getAjax', 'chkemailexist', 'chkphoneexist', 'getNewsLetter']); 
        $this->loadComponent('RequestHandler');   
    }

    /**
     * News letter Method
     *
     * @access public
     */
    public function getNewsLetter(){
        //echo '<pre>'; print_r($_POST); die;
         $this->viewBuilder()->setLayout('ajax');
          if ($this->request->is(array('ajax', 'post'))) {
            $postData = $this->request->getData();
            $newData = [];
            $newData['email'] = $postData['newsEmail'];
            $newsletter = TableRegistry::get('NewLetters');
            $news = $newsletter->newEntity();
            $newsletterData = $newsletter->patchEntity($news, $newData);
            if($newsletter->save($newsletterData)){
                echo 1;
            }
            exit();
          }
      }

      /**
     * News get Ajax Method
     *
     * @access public
     */
      public function getAjax(){
        //echo '<pre>'; print_r($_POST); die;
        $this->viewBuilder()->setLayout('ajax');
        if ($this->request->is(array('ajax', 'post'))) {
             $postData = $this->request->getData();
              //check email exist
              if ($this->Users->exists(['email' => $postData['email'], 'Users.user_type' => 3])) {echo '2'; exit;}
                
                $newData = [];
                $newData['firstname'] = $postData['firstname'];
                $newData['lastname'] = $postData['lastname'];
                $newData['password'] = $this->getToken(8);
                $newData['email'] = $postData['email'];
                $newData['user_type'] = 3;

                $newData['user_profile']['phone_number'] = $postData['phone_number'];
                $newData['user_profile']['description'] = $postData['description'];

                $data['firstname'] = $postData['firstname'];
                $data['email'] = $postData['email'];
                $data['password'] = $newData['password'];
                
                $userentity = $this->Users->newEntity();
                $userData = $this->Users->patchEntity($userentity, $newData, ['associated' => ['UserProfiles']]);
               //echo '<pre>'; print_r($userData->errors()); die;
                //emai sent mail to email and password
                if($this->Users->save($userData)){
                    $email = new Email();
                        $email
                        ->template('restautantlogin')
                        ->subject('Restaurant login Credentials')
                        ->emailFormat('both')
                        ->viewVars($data)
                        ->to($postData['email'])
                        ->from('deepak.uniyal@evontech.com')
                        ->send();
                    echo 1;
                }
                exit;
            }
        }

        //function to getToken
        protected function getToken($length) {
          $token = "";
          $codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
          $codeAlphabet .= "abcdefghijklmnopqrstuvwxyz";
          $codeAlphabet .= "0123456789";
          $max = strlen($codeAlphabet); // edited

            for ($i = 0; $i < $length; $i++) {
            $token .= $codeAlphabet[$this->crypto_rand_secure(0, $max - 1)];
            }
          return $token;
        }

         //function to crypto_rand_secure
        protected function crypto_rand_secure($min, $max) {
          $range = $max - $min;
          if ($range < 1)
          return $min; // not so random...
          $log = ceil(log($range, 2));
          $bytes = (int) ($log / 8) + 1; // length in bytes
          $bits = (int) $log + 1; // length in bits
          $filter = (int) (1 << $bits) - 1; // set all lower bits to 1
          do {
          $rnd = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
          $rnd = $rnd & $filter; // discard irrelevant bits
          } while ($rnd > $range);
          return $min + $rnd;
        }

      /**
     * check email exist Method
     *
     * @access public
     */
      public function chkemailexist(){
       $email =  $this->request->getQuery('email');
        $users = $this->Users->find()->where(['Users.email' => $email, 'Users.user_type' => 3, 'Users.is_deleted' => 0])->first();
        if(!empty($users)){
            echo 'false';
        }else{
            echo 'true';
        }
        exit();
      }

      /**
     * check phone number exist Method
     *
     * @access public
     */
      public function chkphoneexist(){
        $userprofiles = TableRegistry::get('UserProfiles');
       $phone_number =  $this->request->getQuery('phone_number');
        $userprofiles = $userprofiles->find()->where(['UserProfiles.phone_number' => $phone_number])->first();
        if(!empty($userprofiles)){
            echo 'false';
        }else{
            echo 'true';
        }
        exit();
      }

     /**
     * Index Method
     *
     * @access public
     */
     public function index(){
        return $this->redirect(['action' => 'login']);
    }

    /**
     * login Method
     *
     * @access public
     */
    public function login()
    {
    	$this->viewBuilder()->setLayout('adminlogin');

	    	if ($this->request->is('post')) {
	        $user = $this->Auth->identify();
	        if ($user) {
	            $this->Auth->setUser($user);
	            return $this->redirect($this->Auth->redirectUrl());
	        }
	        $this->Flash->error('Your username or password is incorrect.');
	    }
    }

    /**
     * logout Method
     *
     * @access public
     */
    public function logout()
    {
        $this->Flash->success(__('You are now logged out.'));
        return $this->redirect($this->Auth->logout());
    }

     /**
     * dashboard Method
     *
     * @access public
     */
     public function dashboard(){}

     /**
     * restautant List Method
     *
     * @access public
     */
     public function restautantList(){
       // $this->viewBuilder()->setLayout('admindefault');
        //$conditions['not']['Users.id'] = 1;
        $conditions = ['Users.id !=' => 1, 'Users.user_type !=' => 2];
            $this->paginate = [
                'limit' => 10,
                'conditions' => $conditions
            ];
        $users = $this->Users->find()->where(['Users.is_deleted' => 0])->order(['Users.id' => 'DESC'])->contain(['UserProfiles']);
        $usersData = $this->paginate($users);
        //echo '<pre>'; print_r($usersData); die;
        $this->set(compact('usersData'));
      }

      /**
     * add restautant Method
     *
     * @access public
     */
        public function addRestaurant(){
            //echo '<pre>'; print_r($this->request->getData()); die;
        	 $users = $this->Users->newEntity();
                if ($this->request->is(['post'])) {
                        if ($this->Users->exists(['email' => $this->request->getData('email')])) {
                            return $this->Flash->success(__(EMAIL_EXISTS));
                        }
                        if(!empty($this->request->getData())){
                            $users = $this->Users->patchEntity($users, $this->request->getData(), ['associated' => ['UserProfiles']]);
                        $users->username = $this->request->getData('firstname'). ' '. $this->request->getData('lastname');
                        if ($this->Users->save($users)) {
                            $this->Flash->success(__('Your has been saved.'));
                            return $this->redirect(['action' => 'restautantList']);
                        } 
                    }
                        $this->Flash->error(__('Unable to add your data.'));
                    }
                    $this->set('users', $users);
                }

      /**
      * @description Function to change the Status of the User i.e approved or disapproved..
      *
      * @param type $userId
      * @param type $status
      */
      public function changeStatus($userId = NULL, $status = NULL) {
        //echo 'check'; die;
        if (!$userId) {
           $this->redirect(array('controller' => 'users', 'action' => 'restautant-list'));
        }
        $userdata = $this->Users->find()->where(['Users.id' => $userId, 'Users.user_type' => 3])->first();
            $userEmail = $userdata->email;
            $newData['firstname'] = $userdata->firstname;
                if ($status == 0) {
                //mail send
                    $this->Users->updateAll(array("status" => 0), array("Users.id" => $userId));
                    $this->Flash->success(__(USER_DEACTIVATED));
                }else{
                    $email = new Email();
                        $email
                        ->template('useractive')
                        ->subject('User Active')
                        ->emailFormat('both')
                        ->viewVars($newData)
                        ->to($userEmail)
                        ->from('deepak.uniyal@evontech.com')
                        ->send();
                    $this->Users->updateAll(array("status" => 1), array("Users.id" => $userId, 'Users.user_type' => 3));
                    $this->Flash->success(__(USER_ACTIVATED));
                }
                $this->redirect(array('controller' => 'users', 'action' => 'restautant-list'));
            }

        /**
        * edit restautant List Method
        *
        * @access public
        */
          public function editRestaurant($id=null){
            $users = $this->Users->get($id, ['contain' => ['UserProfiles', 'RestaurantTimes']]);
              if ($this->request->is(['post', 'put'])) {
                    $docFileArray = $this->request->getData();
                    $errors = [];
                     $allowedFormats = array("jpeg", "jpg", "png");
                     $imgeName = $docFileArray["user_profile"]["profile_image"]["name"];
                         //check file size
                      if ($docFileArray["user_profile"]["profile_image"]["size"] > 5000000) {
                          return $this->Flash->success('<b>' . $docFileArray["user_profile"]["profile_image"]["name"] . " :</b> <font color=red>" . FILE_NOT_UPLOADED . "</font><br>");
                      }
                        //check file extension
                      $pathInfo = pathinfo($docFileArray["user_profile"]["profile_image"]["name"]);
                      //echo '<pre>'; print_r($pathInfo); die;
                          if (!in_array($pathInfo["extension"], $allowedFormats)) {
                              return $this->Flash->success('<b>' . $docFileArray["user_profile"]["profile_image"]["name"] . " :</b> <font color=red>" . EXTENSION_NOT_SUPPORTED . "</font><br>");
                      }
                        
                     $path = WWW_ROOT . '' . 'img/restaurant_uploads/';
                     $fileName = time() . '_' . $docFileArray["user_profile"]["profile_image"]["name"];
                     $filePath = $path . $fileName;
                       //check file exist
                      if (!file_exists($path)) {
                          mkdir($path, 0777);
                      }
                      move_uploaded_file($docFileArray["user_profile"]["profile_image"]["tmp_name"], $filePath);
                      if(!empty($users['user_profile']['profile_image'])){
                      //unlink file
                          unlink($path.$users['user_profile']['profile_image']);
                      }

                      $docFileArray['user_profile']['profile_image'] = $fileName;

                      $users = $this->Users->patchEntity($users, $docFileArray);
                       //echo '<pre>'; print_r($users); die;
                          if ($this->Users->save($users)) {
                              $this->Flash->success(__('Your data has been updated.'));
                              return $this->redirect(['action' => 'restautantList']);
                          }
                          $this->Flash->error(__('Unable to add your data.'));
                        }
                        $this->set('users', $users);
                      }

        /**
        * view restautant List Method
        *
        * @access public
        */
        public function viewRestaurant($id=null){
             $users = $this->Users->get($id, ['contain' => ['UserProfiles']]);
                $this->set('users', $users);
        }

        /**
        * delete restautant List Method
        *
        * @access public
        */
        public function deleteRestaurant($id=null){
            $this->Users->updateAll(array('is_deleted' => 1), array('id' => $id));
            return $this->redirect(['action' => 'restautantList']);
        }

    }